/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OtpErlangList
extends OtpErlangObject
implements Iterable<OtpErlangObject>,
Serializable,
Cloneable {
    static final long serialVersionUID = 5999112769036676548L;
    private static final OtpErlangObject[] NO_ELEMENTS = new OtpErlangObject[0];
    private final OtpErlangObject[] elems;
    private OtpErlangObject lastTail = null;

    public OtpErlangList() {
        this.elems = NO_ELEMENTS;
    }

    public OtpErlangList(String string) {
        if (string == null || string.length() == 0) {
            this.elems = NO_ELEMENTS;
        } else {
            int[] nArray = OtpErlangString.stringToCodePoints(string);
            this.elems = new OtpErlangObject[nArray.length];
            for (int i = 0; i < this.elems.length; ++i) {
                this.elems[i] = new OtpErlangInt(nArray[i]);
            }
        }
    }

    public OtpErlangList(OtpErlangObject otpErlangObject) {
        this.elems = new OtpErlangObject[]{otpErlangObject};
    }

    public OtpErlangList(OtpErlangObject[] otpErlangObjectArray) {
        this(otpErlangObjectArray, 0, otpErlangObjectArray.length);
    }

    public OtpErlangList(OtpErlangObject[] otpErlangObjectArray, OtpErlangObject otpErlangObject) throws OtpErlangException {
        this(otpErlangObjectArray, 0, otpErlangObjectArray.length);
        if (otpErlangObjectArray.length == 0 && otpErlangObject != null) {
            throw new OtpErlangException("Bad list, empty head, non-empty tail");
        }
        this.lastTail = otpErlangObject;
    }

    public OtpErlangList(OtpErlangObject[] otpErlangObjectArray, int n, int n2) {
        if (otpErlangObjectArray != null && n2 > 0) {
            this.elems = new OtpErlangObject[n2];
            System.arraycopy(otpErlangObjectArray, n, this.elems, 0, n2);
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public OtpErlangList(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        int n = otpInputStream.read_list_head();
        if (n > 0) {
            this.elems = new OtpErlangObject[n];
            for (int i = 0; i < n; ++i) {
                this.elems[i] = otpInputStream.read_any();
            }
            if (otpInputStream.peek1() == 106) {
                otpInputStream.read_nil();
            } else {
                this.lastTail = otpInputStream.read_any();
            }
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public int arity() {
        return this.elems.length;
    }

    public OtpErlangObject elementAt(int n) {
        if (n >= this.arity() || n < 0) {
            return null;
        }
        return this.elems[n];
    }

    public OtpErlangObject[] elements() {
        if (this.arity() == 0) {
            return NO_ELEMENTS;
        }
        OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[this.arity()];
        System.arraycopy(this.elems, 0, otpErlangObjectArray, 0, otpErlangObjectArray.length);
        return otpErlangObjectArray;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    protected String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = n; i < this.arity(); ++i) {
            if (i > n) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.elems[i].toString());
        }
        if (this.lastTail != null) {
            stringBuffer.append("|").append(this.lastTail.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        this.encode(otpOutputStream, 0);
    }

    protected void encode(OtpOutputStream otpOutputStream, int n) {
        int n2 = this.arity() - n;
        if (n2 > 0) {
            otpOutputStream.write_list_head(n2);
            for (int i = n; i < n2 + n; ++i) {
                otpOutputStream.write_any(this.elems[i]);
            }
        }
        if (this.lastTail == null) {
            otpOutputStream.write_nil();
        } else {
            otpOutputStream.write_any(this.lastTail);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangList)) {
            return false;
        }
        OtpErlangList otpErlangList = (OtpErlangList)object;
        int n = this.arity();
        if (n != otpErlangList.arity()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.elementAt(i).equals(otpErlangList.elementAt(i))) continue;
            return false;
        }
        OtpErlangObject otpErlangObject = otpErlangList.getLastTail();
        if (this.getLastTail() == null && otpErlangObject == null) {
            return true;
        }
        if (this.getLastTail() == null) {
            return false;
        }
        return this.getLastTail().equals(otpErlangList.getLastTail());
    }

    public OtpErlangObject getLastTail() {
        return this.lastTail;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(4);
        int n = this.arity();
        if (n == 0) {
            return -826096594;
        }
        for (int i = 0; i < n; ++i) {
            hash.combine(this.elementAt(i).hashCode());
        }
        OtpErlangObject otpErlangObject = this.getLastTail();
        if (otpErlangObject != null) {
            int n2 = otpErlangObject.hashCode();
            hash.combine(n2, n2);
        }
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        try {
            return new OtpErlangList(this.elements(), this.getLastTail());
        }
        catch (OtpErlangException otpErlangException) {
            return null;
        }
    }

    @Override
    public Iterator<OtpErlangObject> iterator() {
        return this.iterator(0);
    }

    private Iterator<OtpErlangObject> iterator(int n) {
        return new Itr(n);
    }

    public boolean isProper() {
        return this.lastTail == null;
    }

    public OtpErlangObject getHead() {
        if (this.arity() > 0) {
            return this.elems[0];
        }
        return null;
    }

    public OtpErlangObject getTail() {
        return this.getNthTail(1);
    }

    public OtpErlangObject getNthTail(int n) {
        int n2 = this.arity();
        if (n2 >= n) {
            if (n2 == n && this.lastTail != null) {
                return this.lastTail;
            }
            return new SubList(this, n);
        }
        return null;
    }

    public String stringValue() throws OtpErlangException {
        if (!this.isProper()) {
            throw new OtpErlangException("Non-proper list: " + this);
        }
        int[] nArray = new int[this.arity()];
        for (int i = 0; i < nArray.length; ++i) {
            OtpErlangObject otpErlangObject = this.elementAt(i);
            if (!(otpErlangObject instanceof OtpErlangLong)) {
                throw new OtpErlangException("Non-integer term: " + otpErlangObject);
            }
            OtpErlangLong otpErlangLong = (OtpErlangLong)otpErlangObject;
            nArray[i] = otpErlangLong.intValue();
        }
        return new String(nArray, 0, nArray.length);
    }

    private class Itr
    implements Iterator<OtpErlangObject> {
        private int cursor;

        private Itr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < OtpErlangList.this.elems.length;
        }

        @Override
        public OtpErlangObject next() {
            try {
                return OtpErlangList.this.elems[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("OtpErlangList cannot be modified!");
        }
    }

    public static class SubList
    extends OtpErlangList {
        private static final long serialVersionUID = 5999112769036676548L;
        private final int start;
        private final OtpErlangList parent;

        private SubList(OtpErlangList otpErlangList, int n) {
            this.parent = otpErlangList;
            this.start = n;
        }

        @Override
        public int arity() {
            return this.parent.arity() - this.start;
        }

        @Override
        public OtpErlangObject elementAt(int n) {
            return this.parent.elementAt(n + this.start);
        }

        @Override
        public OtpErlangObject[] elements() {
            int n = this.parent.arity() - this.start;
            OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[n];
            for (int i = 0; i < otpErlangObjectArray.length; ++i) {
                otpErlangObjectArray[i] = this.parent.elementAt(i + this.start);
            }
            return otpErlangObjectArray;
        }

        @Override
        public boolean isProper() {
            return this.parent.isProper();
        }

        @Override
        public OtpErlangObject getHead() {
            return this.parent.elementAt(this.start);
        }

        @Override
        public OtpErlangObject getNthTail(int n) {
            return this.parent.getNthTail(n + this.start);
        }

        @Override
        public String toString() {
            return this.parent.toString(this.start);
        }

        @Override
        public void encode(OtpOutputStream otpOutputStream) {
            this.parent.encode(otpOutputStream, this.start);
        }

        @Override
        public OtpErlangObject getLastTail() {
            return this.parent.getLastTail();
        }

        @Override
        public Iterator<OtpErlangObject> iterator() {
            return this.parent.iterator(this.start);
        }
    }
}

