/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpPeer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class OtpSelf
extends OtpLocalNode {
    private final ServerSocket sock;
    private final OtpErlangPid pid;

    public OtpSelf(String string) throws IOException {
        this(string, defaultCookie, 0);
    }

    public OtpSelf(String string, String string2) throws IOException {
        this(string, string2, 0);
    }

    public OtpSelf(String string, String string2, int n) throws IOException {
        super(string, string2);
        this.sock = new ServerSocket(n);
        this.port = n != 0 ? n : this.sock.getLocalPort();
        this.pid = this.createPid();
    }

    public OtpErlangPid pid() {
        return this.pid;
    }

    public boolean publishPort() throws IOException {
        if (this.getEpmd() != null) {
            return false;
        }
        OtpEpmd.publishPort(this);
        return this.getEpmd() != null;
    }

    public void unPublishPort() {
        OtpEpmd.unPublishPort(this);
        try {
            if (this.epmd != null) {
                this.epmd.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.epmd = null;
    }

    public OtpConnection accept() throws IOException, OtpAuthException {
        Socket socket = null;
        try {
            socket = this.sock.accept();
            return new OtpConnection(this, socket);
        }
        catch (IOException iOException) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public OtpConnection connect(OtpPeer otpPeer) throws IOException, UnknownHostException, OtpAuthException {
        return new OtpConnection(this, otpPeer);
    }
}

