/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class OtpErlangBitstr
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3781009633593609217L;
    protected byte[] bin;
    protected int pad_bits;

    public OtpErlangBitstr(byte[] byArray) {
        this.bin = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.bin, 0, byArray.length);
        this.pad_bits = 0;
    }

    public OtpErlangBitstr(byte[] byArray, int n) {
        this.bin = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.bin, 0, byArray.length);
        this.pad_bits = n;
        this.check_bitstr(this.bin, this.pad_bits);
    }

    private void check_bitstr(byte[] byArray, int n) {
        if (n < 0 || 7 < n) {
            throw new IllegalArgumentException("Padding must be in range 0..7");
        }
        if (n != 0 && byArray.length == 0) {
            throw new IllegalArgumentException("Padding on zero length bitstr");
        }
        if (byArray.length != 0) {
            int n2 = byArray.length - 1;
            byArray[n2] = (byte)(byArray[n2] & ~((1 << n) - 1));
        }
    }

    public OtpErlangBitstr(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        int[] nArray = new int[]{0};
        this.bin = otpInputStream.read_bitstr(nArray);
        this.pad_bits = nArray[0];
        this.check_bitstr(this.bin, this.pad_bits);
    }

    public OtpErlangBitstr(Object object) {
        try {
            this.bin = OtpErlangBitstr.toByteArray(object);
            this.pad_bits = 0;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Object must implement Serializable");
        }
    }

    private static byte[] toByteArray(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static Object fromByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public byte[] binaryValue() {
        return this.bin;
    }

    public int size() {
        if (this.pad_bits == 0) {
            return this.bin.length;
        }
        if (this.bin.length == 0) {
            throw new IllegalStateException("Impossible length");
        }
        return this.bin.length - 1;
    }

    public int pad_bits() {
        return this.pad_bits;
    }

    public Object getObject() {
        if (this.pad_bits != 0) {
            return null;
        }
        return OtpErlangBitstr.fromByteArray(this.bin);
    }

    @Override
    public String toString() {
        if (this.pad_bits == 0) {
            return "#Bin<" + this.bin.length + ">";
        }
        if (this.bin.length == 0) {
            throw new IllegalStateException("Impossible length");
        }
        return "#Bin<" + this.bin.length + "-" + this.pad_bits + ">";
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_bitstr(this.bin, this.pad_bits);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangBitstr)) {
            return false;
        }
        OtpErlangBitstr otpErlangBitstr = (OtpErlangBitstr)object;
        if (this.pad_bits != otpErlangBitstr.pad_bits) {
            return false;
        }
        int n = this.bin.length;
        if (n != otpErlangBitstr.bin.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.bin[i] == otpErlangBitstr.bin[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(15);
        hash.combine(this.bin);
        hash.combine(this.pad_bits);
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangBitstr otpErlangBitstr = (OtpErlangBitstr)super.clone();
        otpErlangBitstr.bin = (byte[])this.bin.clone();
        otpErlangBitstr.pad_bits = this.pad_bits;
        return otpErlangBitstr;
    }
}

