'use strict';

angular.module('referl.directives').directive('reSigmaGraph', function($document) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs){
            var sInstance = new sigma({
                settings:
                {
                    defaultLabelColor: '#000',
                    defaultEdgeType: 'curvedArrow',
                    minArrowSize: 5,
                    font: 'arial',
                    edgeColor: 'source',
                },
                renderers: [{container: 'sigma-result', type: 'canvas'}]
                });
            var config = {
                            node: {
                                show: 'overNode',
                                hide: 'outNode',
                                cssClass: 'sigma-tooltip',
                                position: 'top',
                                template:
                                        '<div class=arrow></div>' +
                                        '<div class=sigma-tooltip-header>{{ label }}</div>' +
                                        '<div class="sigma-tooltip-body"> <table>' +
                                            '<tr><th>Type</th> <td>{{ type }}</td></tr>' +
                                             '<tr><th>SubNodes</th> <td>{{ sub_nodes }}</td></tr> </table> </div>' +
                                        '<div class="sigma-tooltip-footer">Number of connections: {{degree}} </div>',
                                renderer: function(node, template)
                                {
                                  // The function context is s.graph
                                  node.degree = this.degree(node.id);

                                  if(!node.sub_nodes)
                                  {
                                    node.sub_nodes = 'None';
                                  }

                                  // Returns an HTML string:
                                  return Mustache.render(template, node);

                        }}};
            var tooltips = sigma.plugins.tooltips(sInstance, sInstance.renderers[0], config);

            sInstance.bind('clickNodes', function(event) {
                            var clicked_node = event.data.node[0];
                            var neighbors = {};
                            angular.forEach(sInstance.graph.edges(), function(e){
                                if(clicked_node.id != e.source && clicked_node.id != e.target) {
                                    e.hidden = true;
                                } else {
                                    neighbors[e.source] = true;
                                    neighbors[e.target] = true;
                                }
                            });
                            angular.forEach(sInstance.graph.nodes(), function(n){
                                n.hidden = !neighbors[n.id]
                                // && sInstance.graph.nodes().findIndex(function(node){ return node.id == n.id }) != 0;
                            });
                            sInstance.refresh();
                        });
            sInstance.bind("outNodes", function(event) {
                angular.forEach(sInstance.graph.edges(), function(e){
                    e.hidden = false;
                    });
                angular.forEach(sInstance.graph.nodes(), function(n){
                    n.hidden = false;
                    });
                sInstance.refresh();
                });

            scope.$watch(attrs.reSigmaGraph, function(value) {
                console.log(value);
                console.log(attrs.reSigmaGraph);
                angular.forEach(value.nodes, function(node) {
                    if (node.type == "function") {
                        node.size = 6;
                        node.color = "#0000FF";
                    } else if (node.type == "module") {
                        node.size = 6;
                        node.color = "#FF0000";
                    } else {
                        node.size = 6;
                        node.color = "#00FF00";
                    }
                });
                angular.forEach(value.edges, function(edge) {
                    if (edge.source == "root" || edge.color != "red")
                        edge.type = "arrow";
                });
                sInstance.graph.clear();
                sInstance.graph.read(value);
                sInstance.refresh();
            });
        }
    };
});
