import  { Range } from 'vscode';

/**
 * Processes response for a database contents request
 * @param Log Received response
 * @returns Response to display for the extension
 */
export function CreateLsResponse(Log:any):{Event:string, Data:string}{
    let ToRet = [];
    if(!Log[1]){ToRet.push('The database is empty.');}
    else{
        ToRet.push('Files in the database:');
        for(let Elem of Log[1]){
            ToRet.push(Elem[0]);
        }
    }
    return {Event: 'output', Data: ToRet.join('\n')};
}

/**
 * Processes response for a transform request
 * @param Log Received response
 * @returns Response to display for the extension
 */
export function CreateTransformResponse(Log:any):{Event:string, Data:string}{
    if(Log[1][0] !== "result"){
        return {
            Event: 'output',
            Data: "RefactorErl Error: "+JSON.stringify(Log[1][1][1])};
    }
    return {Event: 'output', Data: "RefactorErl: Transformation done."};
}

/**
 * Processes the response for a duplicate code search request
 * @param Log Received response
 * @returns If succesful the data is sent to the view class, error message is displayed otherwise
 */
export function CreateDuplicateResponse(Log:any):{Event:string, Data:any}{
    if(Log[0] !== "ok"){
        return {Event: 'error', Data: JSON.stringify(Log[1][1])};
    }
    if(Log[1][3][1] === ""){
        return {
            Event: 'output',
            Data: "There are no duplicate codes in the selected area."
        };
    }
    let ReturnData = [];
    let No = 1;
    for(let Elem of Log[1][3][1]){
        let DataArr = [];
        for(let Item of Elem){
            DataArr.push({Path:Item[0][1],
            Range:new Range(parseInt(Item[1][1][0])-1, parseInt(Item[1][1][1]),
                            parseInt(Item[2][1][0])-1, parseInt(Item[2][1][1]))});
        }
        ReturnData.push({
            CloneName: Log[1][2][1],
            PathRange: DataArr,
            Group_No: No
        });
        No++;
    }
    return {Event: 'dup_code', Data: ReturnData};
}

/**
 * Processes the response for a semantic query request
 * @param Log Received response
 * @returns If succesful the data is sent to the view class, error message is displayed otherwise
 */
export function CreateSQResponse(Log:any):{Event:string, Data:any}{
    if(Log[1] === "" || Log[1][0] !== "result"){
        return {
            Event: 'output',
            Data: JSON.stringify(Log[1] === "" ? "ok" : Log[1][1])};
        }
    if(!Array.isArray(Log[1][1][0][1])){
        return {Event: 'output', Data: "There are no results for this query."};
    }
    return {
        Event: 'sq_result',
        Data: Log[1][1][0][1].filter((arg:any) => { return arg[0] !== "nopos"; })
    };
}

/**
 * Processes the response for a dependency graph request
 * @param Log Received response
 * @returns If succesful the data is sent to the view class, error message is displayed otherwise
 */
export function CreateGraphResponse(Log:any):{Event:string, Data:any}{
    if(Log[0] !== "ok"){ return {Event: 'output', Data: JSON.stringify(Log[1])}; }
    if(Log[1] === ""){ return {Event: 'output', Data: "Dep. Graph: No results"}; }
    return {Event: 'dep_graph', Data:Log[1]};
}

/**
 * Processes the response for a metric query request
 * @param Log Received response
 * @returns Response to display for the extension
 */
export function CreateMetricQueryResponse(Log:any):{Event:string, Data:any}{
    if(Log[1][0] !== "result"){ return {Event:'output', Data:Log[1][1]}; }
    return {Event:'output', Data:Log[1][1][0][1]};
}