/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.refactoring;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListInputDialog extends Dialog {

	private String title;
	private String message;
	private List<String> elementLabel;
	private List<String> elementDefaults;

	public ListInputDialog(Shell parentShell, String title,
			String message, List<String> elementLabel,
			List<String> elementDefaults) {
		super(parentShell);
		this.title = title;
		this.message = message;
		this.elementLabel = elementLabel;
		this.elementDefaults = elementDefaults;
	}

	private List<Text> texts = null;
	private List<String> values = null;

	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);

		Label label = new Label(parent, SWT.LEFT);
		label.setText(message);

		texts = new ArrayList<Text>();

		for (int i = 0; i < elementLabel.size(); ++i) {
			texts.add(createLabelledText(parent, elementLabel.get(i),
					elementDefaults.get(i)));
		}

		return area;
	}

	private Text createLabelledText(Composite parent, String labelLabel,
			String defaultValue) {
		Label label = new Label(parent, SWT.LEFT);
		label.setText(labelLabel);
		Text text = new Text(parent, SWT.SINGLE | SWT.BORDER);
		text.setText(defaultValue);
		return text;
	}

	@Override
	protected void okPressed() {
		values = new ArrayList<String>();
		for (Text text : texts) {
			values.add(text.getText());
		}

		super.okPressed();
	}

	public List<String>getValues() {
		return values;
	}

}
