/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.refactorerl.ui.logic.queries.QueryResultElement;

public class QueryResultContentProvider implements ITreeContentProvider {

	@Override
	public void dispose() {

	}

	private Viewer viewer;
	private SortedMap<String, List<QueryResultElement>> input;

	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		this.viewer = viewer;
		if (!(newInput instanceof Map))
			return; 

		input = (SortedMap<String, List<QueryResultElement>>) newInput; 

	}

	@Override
	public Object[] getElements(Object inputElement) { 
		return input.keySet().toArray();

	}

	@Override
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof String) {
			String parent = (String) parentElement;

			return input.get(parent).toArray(); 
		} else
			return null; // empty array?
	}

	@Override
	public Object getParent(Object element) {
		if (element instanceof QueryResultElement) {
			for (SortedMap.Entry<String, List<QueryResultElement>> entry : input
					.entrySet()) {
				for (QueryResultElement q : entry.getValue()) {
					if (q.equals((QueryResultElement) element))
						return entry.getKey();

				}

			}
			return null; // element not in tree
		} else
			return null; // root?
	}

	@Override
	public boolean hasChildren(Object element) {
		if (element instanceof String) 
			return (element instanceof String) ? !input.get((String)element).isEmpty() : false;
		else
			return false;
	}

}
