/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.IServiceLocator;

/**
 * Creates the semantic query bar widget in the Workbench toolbar.  
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class QueryBar extends WorkbenchWindowControlContribution {

	private Text t;
	private final Color grey = new Color(Display.getCurrent(), 190, 190, 190);
	private final Color black = new Color(Display.getCurrent(), 0, 0, 0);

	
	@Override
	protected Control createControl(Composite parent) {

		t = new Text(parent, SWT.SINGLE | SWT.BORDER);
	
		ContentProposalAdapter autoCompleteAdapter = new QueryContentProposalAdapter(t);
		
		resetText();
		t.addFocusListener(new FocusListener() {

			@Override
			public void focusLost(FocusEvent e) {
				resetText();

			}

			@Override
			public void focusGained(FocusEvent e) {
				t.setForeground(black);
				t.setText(""); //$NON-NLS-1$

			}
		});

		t.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				return;

			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				String query = t.getText();

				if (query.trim().length() > 0) {
					
					IServiceLocator serviceLocator = PlatformUI.getWorkbench();
					ICommandService commandService = (ICommandService) serviceLocator.getService(ICommandService.class);
					Command command = commandService.getCommand("com.refactorerl.ui.query"); //$NON-NLS-1$
				    try {
				    	Map<String, String> parameters = new HashMap<>();
				    	parameters.put("com.refactorerl.ui.queryParameter", "global"); //$NON-NLS-1$ //$NON-NLS-2$
				    	parameters.put("com.refactorerl.ui.queryContentParameter", query); //$NON-NLS-1$
				    	
						command.executeWithChecks(new ExecutionEvent(command, parameters, this, null));
					} catch (ExecutionException | NotDefinedException
							| NotEnabledException | NotHandledException e1) {
						
					}
				}

				t.setText(""); //$NON-NLS-1$
			}
		});
		return null;
	}

	private void resetText() {
		if (t != null) {
			t.setForeground(grey);
			t.setText(Messages.QueryBar_6);
		}
	}

}
