/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import com.refactorerl.ui.logic.filelist.ResetDbRequest;
import com.refactorerl.ui.presentation.Activator;

public class ResetDbHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {

		final IWorkbenchWindow wb = HandlerUtil.getActiveWorkbenchWindow(event);

		boolean b = MessageDialog.openConfirm(wb.getShell(), Messages.ResetDbHandler_0, Messages.ResetDbHandler_1
				+ Messages.ResetDbHandler_2);
		if(!b) return null;
		
		Activator.executeRequest(new ResetDbRequest(Activator.getProxy(), null), wb.getShell());

		wb.getShell().getDisplay().asyncExec(new Runnable() {

			@Override
			public void run() {
				final FileListView fileListView = (FileListView) wb.getActivePage()
						.findView("com.refactorerl.ui.fileListView"); //$NON-NLS-1$
				if (fileListView != null)
					fileListView.reload();
			}
		});

		return null;
	}

}
