/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.logic.filelist.DelEnvRequest;
import com.refactorerl.ui.presentation.Activator;

/**
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class DelEnvHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {

		IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow(event).getActivePage();
		Shell shell = activePage.getActivePart().getSite().getShell();

		ISelection selection = activePage.getSelection();

		List<String> filepaths = new LinkedList<>();

		if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection))
			return null;

		IStructuredSelection sSelection = (IStructuredSelection) selection;
		final List<Pair<String, String>> envsToDelete = new ArrayList<>();

		if (!(sSelection.getFirstElement() instanceof Pair<?, ?>))
			return null;

		Iterator<?> it = sSelection.iterator();
		try {
			while (it.hasNext()) {
				Pair<String, String> next = (Pair<String, String>) it.next();
				envsToDelete.add(next);

				String envName = next.key;
				String envVal = next.value;

			}
		} catch (ClassCastException e) {
			// not a selection in envs view, do nothing
		}
		MessageDialog md = new MessageDialog(shell, Messages.DelEnvHandler_0, null,
				Messages.DelEnvHandler_1, MessageDialog.QUESTION, new String[] { Messages.DelEnvHandler_2, Messages.DelEnvHandler_3 }, 0) {
			@Override
			protected Control createCustomArea(Composite parent) {
				Control control = super.createCustomArea(parent);

				Table table = new Table(parent, SWT.BORDER | SWT.V_SCROLL);
				table.setHeaderVisible(true);
				TableColumn c1 = new TableColumn(table, SWT.NULL);
				c1.setText(Messages.DelEnvHandler_4);
				TableColumn c2 = new TableColumn(table, SWT.NULL);
				c2.setText(Messages.DelEnvHandler_5);

				for (Pair<String, String> pair : envsToDelete) {
					TableItem item = new TableItem(table, SWT.NULL);
					item.setText(0, pair.key);
					item.setText(1, pair.value);
				}
				c1.pack();
				c2.pack();
				return table;
			}
		};
		int answ = md.open();
		if (answ == 1)
			return null;

		for (Pair<String, String> pair : envsToDelete) {
			Activator.executeRequest(new DelEnvRequest(pair.key, pair.value, Activator.getProxy(), null), HandlerUtil
					.getActiveWorkbenchWindow(event).getShell());
		}

		try {
			EnvsView view = ((EnvsView) HandlerUtil.getActiveWorkbenchWindow(event).getActivePage()
					.showView("com.refactorerl.ui.envsView")); //$NON-NLS-1$
			if (view != null) {
				view.reload();
			}
		} catch (PartInitException e) {
			Activator.showErrorDialog(e, HandlerUtil
					.getActiveWorkbenchWindow(event).getShell());
		} 
		return null;
	}
}
