/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.event;

import org.osgi.service.event.Event;

import com.refactorerl.ui.communication.event.IEvent;

/**
 * Wrapper of an OSGi Event.
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class ReferlEvent implements IEvent {

	private final Event event;

	public ReferlEvent(Event event){
		this.event = event;
	}

	@Override
	public Object getProperty(String name) {
		return event.getProperty(name);
	}

	@Override
	public boolean containsProperty(String name) {
		return event.containsProperty(name);
	}

	@Override
	public String[] getPropertyNames() {
		return event.getPropertyNames();
	}

	@Override
	public String getTopic() {
		return event.getTopic();
	}

}
