/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
 */

package com.refactorerl.ui.presentation.dupcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import com.refactorerl.ui.common.FilePosition;
import com.refactorerl.ui.logic.dupcode.GroupData;
import com.refactorerl.ui.presentation.codebrowser.StringInput;
import com.refactorerl.ui.presentation.codebrowser.StringStorage;

public class TwinPaneEditorInput implements IEditorInput {
	final private Map<StringInput, FilePosition> filePositions = new HashMap<>();
	final private List<StringInput> stringInputs = new ArrayList<>();
	final public GroupData groupData;
	
	public TwinPaneEditorInput(GroupData groupData) {
		super();
		
		this.groupData = groupData;
		
		for (FilePosition fp : groupData.getMembers()) {
			StringInput strInput = new StringInput(new StringStorage(fp.filePath));
			stringInputs.add(strInput);
			filePositions.put(strInput, fp);
		}

	}
	
	public Map<StringInput, FilePosition> getFilePositions(){
		return Collections.unmodifiableMap(filePositions);
	}
	public List<StringInput> getStringInputs(){
		return Collections.unmodifiableList(stringInputs);
	}	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((groupData == null) ? 0 : groupData.hashCode());
		result = prime * result
				+ ((stringInputs == null) ? 0 : stringInputs.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TwinPaneEditorInput other = (TwinPaneEditorInput) obj;
		if (groupData == null) {
			if (other.groupData != null)
				return false;
		} else if (!groupData.equals(other.groupData))
			return false;
		if (stringInputs == null) {
			if (other.stringInputs != null)
				return false;
		} else if (!stringInputs.equals(other.stringInputs))
			return false;
		return true;
	}

	@Override
	public Object getAdapter(Class adapter) {

		return null;
	}

	@Override
	public boolean exists() {

		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {

		return null;
	}

	@Override
	public String getName() {

		return null;
	}

	@Override
	public IPersistableElement getPersistable() {

		return null;
	}

	@Override
	public String getToolTipText() {

		return null;
	}

}