/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.dependency;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

abstract class ModuleFunctionControlPanel extends ControlPanel {
	Composite cmp;
	Button excludeOtpButton;
	org.eclipse.swt.widgets.List starts;
	org.eclipse.swt.widgets.List excludeds;
	org.eclipse.swt.widgets.List excludedLeaves;

	public ModuleFunctionControlPanel(Composite parent, FormToolkit toolkit,
			List<Control> hideWhenErlSelected,
			List<Control> hideWhenHTMLSelected,
			List<Control> hideWhenModuleBlockSelected,
			List<String> proposals, String startText, String excludeText,
			String excludedLeavesText) {
		super(parent, toolkit, hideWhenErlSelected, hideWhenHTMLSelected, hideWhenModuleBlockSelected);
		cmp = toolkit.createComposite(parent);
		cmp.setLayout(new GridLayout(2, false));
		excludeOtpButton = createExcludeOtpControlsOnGridLayout(cmp);

		starts = createLabelledListOnGridLayout(cmp, proposals, startText);
		excludeds = createLabelledListOnGridLayout(cmp, proposals,
				excludeText, hideWhenErlSelected);
		excludedLeaves = createLabelledListOnGridLayout(cmp, proposals,
				excludedLeavesText, hideWhenErlSelected);

	}

	@Override
	public Composite getComposite() {
		return cmp;

	}

	private Button createExcludeOtpControlsOnGridLayout(
			Composite moduleControl) {
		Label excludeOtpLabel = toolkit.createLabel(moduleControl,
				Messages.ModuleFunctionControlPanel_0);
		configureGridData(excludeOtpLabel, false);

		Button excludeOtpButton = toolkit.createButton(moduleControl, "", //$NON-NLS-1$
				SWT.CHECK);

		configureGridData(excludeOtpButton, true);

		hideWhenErlSelected.add(excludeOtpLabel);
		hideWhenErlSelected.add(excludeOtpButton);

		return excludeOtpButton;
	}

}