/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.codebrowser;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.commands.ICommandService;

/**
 * Can be added to a JFace viewer so it will execute the "com.refactorerl.ui.showFileCommand" platform command.
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class ShowFileDoubleClickListener implements IDoubleClickListener {

	private Composite parent;
private IViewSite viewSite;
	public ShowFileDoubleClickListener(Composite parent, IViewSite viewSite) {
		this.parent = parent;
		this.viewSite = viewSite;
	}

	@Override
	public void doubleClick(DoubleClickEvent event) {
		
		ICommandService commandService = (ICommandService) viewSite
				.getService(ICommandService.class);

		try {
	
			Command command = commandService
					.getCommand("com.refactorerl.ui.showFileCommand"); //$NON-NLS-1$
			Map<String, String> pmap = new HashMap<>();
			pmap.put("com.refactorerl.ui.showFileParameter", "use_selection"); //$NON-NLS-1$ //$NON-NLS-2$
			ParameterizedCommand.generateCommand(command, pmap)
					.executeWithChecks(null,
							new ExecutionEvent(command, pmap, null, null));
		} catch (ExecutionException | NotEnabledException | NotHandledException
				| NotDefinedException e) {
			MessageDialog.openError(parent.getShell(), Messages.ShowFileDoubleClickListener_3, e.getMessage());
		}
	}
}