/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.refactorerl.ui.communication.event.IEvent;
import com.refactorerl.ui.communication.event.IEventHandler;

/** Shows RefactorErl job info on status line 
 * */
public class StatusBarEventHandler implements IEventHandler {

	public static enum Status{INFO, ERROR}
	
	public static class StatusMessage{
		public final Status status;
		public final String message;
		public StatusMessage(Status status, String message) {
			this.status = status;
			this.message = message;
		}
	}
	
	@Override
	public void handleEvent(IEvent event) {
		// Object o = EventDispatcher.getValue(event);
		Object o = Activator.getEdp().getValue(event);
		if(!(o instanceof StatusMessage)) return;
		StatusMessage sm = (StatusMessage) o;
		switch(sm.status){
		case ERROR:
			setErrorMessage(sm.message);
			break;
		case INFO:
			setMessage(sm.message);
			break;
		default:
			return;		
		}
		
	}

	private void setMessage(final String message) {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				IStatusLineManager statusLineManager = getStatusLineManager();
				if (statusLineManager != null)
					statusLineManager.setMessage(message);
			}
		});

	}

	private void setErrorMessage(final String message) {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				IStatusLineManager statusLineManager = getStatusLineManager();
				if (statusLineManager != null)
					statusLineManager.setErrorMessage(message);
			}
		});

	}

	private IStatusLineManager getStatusLineManager() {
		try {

			IWorkbench wb = PlatformUI.getWorkbench();
			IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
			IWorkbenchPage page = win.getActivePage();

			IWorkbenchPart part = page.getActivePart();
			IWorkbenchPartSite site = part.getSite();

			IActionBars actionBars;

			if (site instanceof IViewSite) {
				IViewSite viewSite = (IViewSite) site;
				actionBars = viewSite.getActionBars();
			} else if (site instanceof IEditorSite) {
				IEditorSite editorSite = (IEditorSite) site;
				actionBars = editorSite.getActionBars();
			} else
				return null;

			IStatusLineManager statusLineManager = actionBars
					.getStatusLineManager();
			return statusLineManager;
		} catch (NullPointerException e) {
			System.out.println(Messages.StatusBarEventHandler_0);
			return null;
		}

	}

}
