/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

import com.refactorerl.ui.communication.IReferlProgressMonitor;


/**
  Wrapper for an IProgressMonitor object
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class ReferlProgressMonitor implements IReferlProgressMonitor {
	private IProgressMonitor monitor;
	private Shell shell;

	public ReferlProgressMonitor(IProgressMonitor monitor, Shell shell) {
		this.monitor = monitor;
		this.shell = shell;
	}

	@Override
	public void beginTask(final String name, final int totalWork) {
		shell.getDisplay().asyncExec(new Runnable() {

			@Override
			public void run() {
				monitor.beginTask(name, totalWork);
			}
		});
	}

	@Override
	public void done() {
		shell.getDisplay().asyncExec(new Runnable() {

			@Override
			public void run() {
				monitor.done();
			}
		});

	}

	@Override
	public void worked(final int work, final String taskName) {
		shell.getDisplay().asyncExec(new Runnable() {

			@Override
			public void run() {
				monitor.worked(work);
				if(taskName != null) monitor.setTaskName(taskName);
			}
		});

	}

}
