/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import com.refactorerl.ui.communication.process.ReferlProcess.DatabaseType;

public class PreferenceInitializer extends AbstractPreferenceInitializer {
	
	@Override
	public void initializeDefaultPreferences() {

		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
//		store.setDefault("logs_dir", System.getProperty("user.dir")+ File.separator + "logs"); 
		store.setDefault("logs_dir", Activator.getDefault().getStateLocation() + File.separator + "logs"); //$NON-NLS-1$ //$NON-NLS-2$
		store.setDefault("data_dir", Activator.getDefault().getStateLocation() + File.separator + "data"); //$NON-NLS-1$ //$NON-NLS-2$
//		store.setDefault("data_dir", System.getProperty("user.dir")+ File.separator + "data"); 
		
		store.setDefault("cookie", ""); //$NON-NLS-1$ //$NON-NLS-2$
		store.setDefault("client_alivename",Activator.generateRandomName());  //$NON-NLS-1$

		 // Full address of remote RefactorErl server, eg. myserver@myhost.org
		store.setDefault("server_address", "refactorerl@localhost");  //$NON-NLS-1$ //$NON-NLS-2$
		
		// True, if the client spawns a new RefactorErl server instead of using a remote one.
		store.setDefault("local_server", false);  //$NON-NLS-1$
		store.setDefault("refactorerl_base_dir", ""); //$NON-NLS-1$ //$NON-NLS-2$
		store.setDefault("local_server_address", "refactorerl@localhost");  //$NON-NLS-1$

		store.setDefault("db_type", DatabaseType.NIF.toString()); //$NON-NLS-1$
		store.setDefault("refactorerl_data_dir", ""); //$NON-NLS-1$ //$NON-NLS-2$
		
		// prints logs to stdout
		store.setDefault("debug_mode", false); //$NON-NLS-1$
	}

	
}
