/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;

public class GeneralContentProposalAdapter extends ContentProposalAdapter {

	/**
	 * This class can be used to add auto-complete functionality to a Text widget.
	 * @param control The Text widget the auto-complete functionality should be added to 
	 * @param proposals The list of strings which will be displayed as proposals for auto-completion
	 */
	public GeneralContentProposalAdapter(Control control, final List<String> proposals) {
		super(control, new TextContentAdapter(), new IContentProposalProvider() {

			@Override
			public IContentProposal[] getProposals(String contents, int position) {
				
				if (contents == null || contents.trim().length() < 1)
					return null;

					List<String> filteredProposals = new ArrayList<>();
					for (String p : proposals) {
						if(p.startsWith(contents))
							filteredProposals.add(p);
					}
				
					if (proposals.isEmpty())
						return new IContentProposal[0];

					ContentProposal[] props = new ContentProposal[filteredProposals
							.size()];
					int i = 0;
					for (String s : filteredProposals) {
						
						props[i] = new ContentProposal(s, null);
						++i;
					}

					return props;			

			}
		}, null, null);
		
		
		setProposalAcceptanceStyle(ContentProposalAdapter.PROPOSAL_REPLACE);

	}
}
