/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.queries;

import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

public class InsertToQueryHistoryRequest extends AbstractRequest<Object> {


	private OtpErlangTuple request;

	public InsertToQueryHistoryRequest(String queryString,
			OtpErlangObject queryResults, String groupBy, String user,
			OtpErlangTuple dbHash, ReferlProxy proxy, Logger logger) {
		this(queryString, null, null, queryResults, groupBy, user, dbHash,
				proxy, logger);
	}

	public InsertToQueryHistoryRequest(String queryString, String file,
			Integer position, OtpErlangObject queryResults, String groupBy,
			String user, OtpErlangTuple dbHash, ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		
		final OtpErlangString safeQuery = new OtpErlangString(
				queryString.replaceAll("[\\n\\r\\s\\t]+", "")); //$NON-NLS-1$ //$NON-NLS-2$
		final OtpErlangObject otpFile = file != null ? new OtpErlangString(file) : new OtpErlangAtom("no_file"); //$NON-NLS-1$
		final OtpErlangObject otpPosition = position != null ? new OtpErlangInt(position): new OtpErlangAtom("no_pos"); //$NON-NLS-1$
		OtpErlangTuple queryKey = OtpErlangHelper.createTuple(safeQuery,
				otpFile, otpPosition,
				new OtpErlangAtom(groupBy));

		request = new OtpErlangTuple(new OtpErlangObject[] { new OtpErlangAtom(
				"update_qtab_if_needed"), queryKey, new OtpErlangString(queryString), new OtpErlangString(user), queryResults, dbHash }); //$NON-NLS-1$
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected Object doProcessReply(OtpErlangObject m) throws RequestException {
		return null;
	}

}
