/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.investigations;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.logic.AbstractRequest;

public class LoadInvestigationRequest extends AbstractRequest<Investigation> {

	private OtpErlangTuple request;

	public LoadInvestigationRequest(String investigationName,
			ReferlProxy proxy, Logger logger) {
		super(proxy, logger);

		request = new OtpErlangTuple(new OtpErlangObject[] {
				new OtpErlangAtom("get_from_invtab"), //$NON-NLS-1$
				new OtpErlangString(investigationName) });
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected Investigation doProcessReply(OtpErlangObject m) {

		OtpErlangObject o = OtpErlangHelper.nth(
				MessageParseHelper.getBody(m), 1);
	
		String name = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(
				o, 1));
		OtpErlangTuple hash = (OtpErlangTuple) OtpErlangHelper.nth(o, 2);

		OtpErlangList users0 = (OtpErlangList) OtpErlangHelper.nth(o, 3);
		List<String> users = new ArrayList<>();
		for (OtpErlangObject user : users0) {
			users.add(OtpErlangHelper.toUnquotedString(user));
		}

		Investigation inv = new Investigation(name, hash);
		inv.addUsers(users);

		OtpErlangList nodes0 = (OtpErlangList) OtpErlangHelper.nth(o, 4);
		for (OtpErlangObject node : nodes0) {
			inv.addNode(processNode(node));
		}		
		return inv;

	}

	private InvestigationNode processNode(OtpErlangObject node) {

		OtpErlangPid pid = (OtpErlangPid) OtpErlangHelper.nth(node, 0);

		OtpErlangObject parentObj = OtpErlangHelper.nth(node, 1);
		OtpErlangPid parent = OtpErlangHelper
				.equalsAtom(parentObj, "no_parent") ? null //$NON-NLS-1$
				: (OtpErlangPid) parentObj;
		OtpErlangTuple data = (OtpErlangTuple) OtpErlangHelper.nth(node, 2);

		OtpErlangList children0 = (OtpErlangList) OtpErlangHelper.nth(node,
				3);
		List<OtpErlangPid> children = new ArrayList<>();
		for (OtpErlangObject cpid : children0) {
			children.add((OtpErlangPid) cpid);
		}

		String name = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(
				data, 1));
		boolean shown = OtpErlangHelper.booleanValue(OtpErlangHelper.nth(
				data, 2));
		OtpErlangObject graphNode = OtpErlangHelper.nth(data, 3);
		String text = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(
				data, 4));
		String label = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(
				data, 5));
		boolean memo = OtpErlangHelper.booleanValue(OtpErlangHelper.nth(
				data, 6));

		String filePath, fileItemLabel;
		filePath = fileItemLabel = null;
		int offset, lineNum, startP, endP;
		offset = lineNum = startP = endP = 0;

		if (!memo) {
			OtpErlangTuple fileData = (OtpErlangTuple) OtpErlangHelper.nth(
					data, 7);
			filePath = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(
					fileData, 0));
			offset = (int) ((OtpErlangLong) OtpErlangHelper.nth(fileData, 1))
					.longValue(); 

			lineNum = (int) ((OtpErlangLong) OtpErlangHelper
					.nth(fileData, 2)).longValue();
			OtpErlangTuple ps = OtpErlangHelper.nth(fileData, 3);
			startP = (int) ((OtpErlangLong) OtpErlangHelper.nth(ps, 0))
					.longValue();
			endP = (int) ((OtpErlangLong) OtpErlangHelper.nth(ps, 1))
					.longValue();
			fileItemLabel = OtpErlangHelper.toUnquotedString(OtpErlangHelper
					.nth(fileData, 4));
		}

		Pair<Integer, Integer> textPosition = new Pair<>(startP, endP);

		OtpErlangTuple sps = (OtpErlangTuple) OtpErlangHelper.nth(data, 8);
		int x = (int) ((OtpErlangLong) OtpErlangHelper.nth(sps, 0))
				.longValue();
		int y = (int) ((OtpErlangLong) OtpErlangHelper.nth(sps, 1))
				.longValue();

		Pair<Integer, Integer> screenPosition = new Pair<>(x, y);

		return new InvestigationNode(pid, parent, children, name, shown, memo,
				graphNode, text, label, filePath, offset, textPosition,
				lineNum, fileItemLabel, screenPosition);

	}

}
