/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.investigations;

import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.logic.AbstractRequest;

public class GetContainerRequest extends AbstractRequest<GetContainerRequest.Container> {

	public class Container {
		final public OtpErlangObject containerNode;
		final public int positionOffset;
		final public int startPosition;
		final public int endPosition;
		final public int lineNumber;
		
		public Container(OtpErlangObject containerNode, int positionOffset,
				int startPosition, int endPosition, int lineNumber) {
			super();
			this.containerNode = containerNode;
			this.positionOffset = positionOffset;
			this.startPosition = startPosition;
			this.endPosition = endPosition;
			this.lineNumber = lineNumber;
		}

		@Override
		public String toString() {
			return "Container [containerNode=" + containerNode //$NON-NLS-1$
					+ ", positionOffset=" + positionOffset + ", startPosition=" //$NON-NLS-1$ //$NON-NLS-2$
					+ startPosition + ", endPosition=" + endPosition //$NON-NLS-1$
					+ ", lineNumber=" + lineNumber + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		}
		
	}
	

	private OtpErlangTuple request;

	public GetContainerRequest(OtpErlangObject node, ReferlProxy proxy,
			Logger logger) {
		super(proxy, logger);
		request = OtpErlangHelper.createTuple(new OtpErlangAtom("get_container"), //$NON-NLS-1$
				node);
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected Container doProcessReply(OtpErlangObject m) {
		OtpErlangObject msg = OtpErlangHelper.nth(
				MessageParseHelper.getBody(m), 1);
		
		OtpErlangObject containerNode = OtpErlangHelper.nth(msg, 0);
		int positionOffset = (int) ((OtpErlangLong) OtpErlangHelper.nth(msg, 1)).longValue();
		OtpErlangObject tuple0 = OtpErlangHelper.nth(msg, 2);
		OtpErlangObject tuple1 = OtpErlangHelper.nth(tuple0, 0);
		int startPosition = (int) ((OtpErlangLong) OtpErlangHelper.nth(tuple1, 0)).longValue();
		int endPosition = (int) ((OtpErlangLong) OtpErlangHelper.nth(tuple1, 1)).longValue();
		
		OtpErlangObject tuple2 = OtpErlangHelper.nth(tuple0, 1);
		OtpErlangObject tuple3 = OtpErlangHelper.nth(tuple2, 0);
		int lineNumber = (int) ((OtpErlangLong) OtpErlangHelper.nth(tuple3, 0)).longValue();
		
		return new Container(containerNode, positionOffset, startPosition, endPosition, lineNumber);
	}
}
