/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.filelist;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.logic.AbstractRequest;

/** @Deprecated This will be slow if there's a file which was parsed with errors. */
public class FileListRequest0 extends AbstractRequest<List<String>> {

	private OtpErlangTuple request;

	public FileListRequest0(ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		request = new OtpErlangTuple(new OtpErlangObject[] { new OtpErlangAtom("filelist") }); //$NON-NLS-1$
	}

	@Override
	protected OtpErlangObject doGetRequest() {

		return request;
	}

	@Override
	protected List<String> doProcessReply(OtpErlangObject msg) {

		List<String> filepaths = new ArrayList<>();
		OtpErlangObject body = MessageParseHelper.getBody(msg);

		OtpErlangList ls = (OtpErlangList) OtpErlangHelper.nth(body, 1);
		for (OtpErlangObject o : ls.elements()) {
			filepaths.add(OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(o, 0)));
		}

		return filepaths;

	}

}
