/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.dupcode;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

/**
 * Returns a list of key-value pairs, where key is the internal name of an
 * algorithm (used by RefactorErl) and value is the human-readable name of the
 * same algorithm.
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class GetAlgorithmsRequest extends
		AbstractRequest<List<Pair<String, String>>> {

	private OtpErlangTuple request;

	public GetAlgorithmsRequest(ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		request = new OtpErlangTuple(new OtpErlangObject[] { new OtpErlangAtom(
				"get_algorithms") }); //$NON-NLS-1$
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected List<Pair<String, String>> doProcessReply(OtpErlangObject m)
			throws RequestException {

		List<Pair<String, String>> keysLabels = new ArrayList<>();
		OtpErlangList ls = (OtpErlangList) OtpErlangHelper.nth(
				MessageParseHelper.getBody(m), 1);
		for (OtpErlangObject o0 : ls) {
			OtpErlangObject o = OtpErlangHelper.nth(o0, 1);
			String key = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(
					OtpErlangHelper.nth(o, 0), 1));
			String label = OtpErlangHelper.toUnquotedString(OtpErlangHelper
					.nth(OtpErlangHelper.nth(o, 1), 1));
			keysLabels.add(new Pair<String, String>(key, label));

		}

		return keysLabels;
	}

}
