/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.communication.event;

/**
 * Classes implementing this interface can be used to subscribe handlers for
 * certain events and to fire these or some other events.
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public interface IEventDispatcher {
	/**
	 * Gets the Object stored by an IEvent received in the handleEvent(Event
	 * event) method of an IEventHandler.
	 * 
	 * @param event
	 * @return
	 */
	public Object getValue(IEvent event) ;

	/**
	 * Used to subscribe an IEventHandler to the given topic. Every event fired
	 * with the supplied topic will trigger the supplied handler.
	 * Use the getValue(IEvent event) to get an Object from the Event in a triggered
	 * IEventHandler.  
	 * Use the unsubscribe(EventHandler handler) method to unsubscribe your handler.  

	 * @param topic
	 * @param handler
	 */
	public void subscribe(String topic, IEventHandler handler);

	/**
	 * Unsubscribe the supplied IEventHandler from every topic.
	 * @param handler
	 */
	public void unsubscribe(IEventHandler handler);

	/**
	 * Triggers every handler subscribed to the supplied topic and
	 * gives them the supplied Object inside an event.
	 * @param topic
	 * @param msg
	 */
	public void fire(String topic, Object msg);

	/**
	 * Initializes this IEventDispatcher instance. Calling this method before
	 * any other non-static method of this class is mandatory.
	 */
	public void start();
	
	/**
	 * Frees up the resources of this IEventDispatcher instance.
	 */
	public void stop();
}
