package com.refactorerl.ui.communication;

import org.junit.Assert;
import org.junit.Test;

import com.refactorerl.ui.common.Common;
import com.refactorerl.ui.communication.process.ReferlProcess;

public class ReferlProcessTest {

	@Test
	public void testStart() {
		// JVM argument is something like:
		// -Drefactorerl_base="/home/daniel/opt/refactorerl-0.9.14.09"
		String baseDirPath = System.getProperty("refactorerl_base");
		String aliveName = Common.createRandomName();

	
		System.out.println("Starting process correct basepath: " + baseDirPath);
		ReferlProcess process = new ReferlProcess(baseDirPath, aliveName,
				ReferlProcess.DatabaseType.NIF, null,
				Common.createLogHandlers());
		Assert.assertTrue(process.start());
		process.stop();
		
		
		System.out.println("Starting process with wrong \"loremipsum\" basepath");
		process = new ReferlProcess("loremipsum", aliveName,
				ReferlProcess.DatabaseType.NIF, null,
				Common.createLogHandlers());

		Assert.assertFalse(process.start());
		process.stop();

		System.out.println("Starting process with illegal \"@@@@@@@@@\" aliveName");

		process = new ReferlProcess(baseDirPath, "@@@@@@@@@",
				ReferlProcess.DatabaseType.NIF, null,
				Common.createLogHandlers());

		Assert.assertFalse(process.start());
		process.stop();

		System.out.println("Starting process correct basepath again: " + baseDirPath);
		process = new ReferlProcess(baseDirPath, aliveName,
				ReferlProcess.DatabaseType.NIF, null,
				Common.createLogHandlers());

		Assert.assertTrue(process.start());

		process.stop();
	}



}
