%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.

-module(reflib_syntax).
-vsn("$Rev: $").

-include("lib.hrl").

-export([node_type/1, first_leaf/0, last_leaf/0, children/1, parent/1, leaves/1,
         flat_text/1, root_path/1, root_path/2, get_file/1]).

%% @spec node_type(Node::node()) -> atom()
%% @doc  The type of the given syntax node.
node_type(Node) ->
    ?Syn:node_type(Node).

%% @spec first_leaf() -> (Node::node()) -> node()
%% @doc  First leaf of syntactic subtree specified by `Node' as root.
first_leaf() ->
    ?Syn:first_leaf().

%% @spec last_leaf() -> (Node::node()) -> node()
%% @doc  Last leaf of syntactic subtree specified by `Node' as root.
last_leaf() ->
    ?Syn:last_leaf().

%% @spec parent(node()) -> [{atom(), node()}]
%% @doc Returns the syntactic parents of a node. Multiple parents are only
%% possible for preprocessed lexical nodes.
parent(Node) ->
    ?Syn:parent(Node).

%% @spec children(Node::node()) -> [{LinkTag::atom(), Children::node()}]
%% @doc Returns the children of the node in the order as they appear in the
%% real syntax tree.
children(Node) ->
    ?Syn:children(Node).

%% @spec leaves(node()) -> [node()]
%% @doc Returns the leaves of the syntactical subtree that starts at `Top',
%% in the correct syntactical order. This yields the original token nodes of
%% the subtree.
leaves(Top) ->
    ?Syn:leaves(Top).

%% @spec flat_text(node()) -> [char()]
%% @doc Returns the textual representation of the syntactical subtree that
%% starts at `Top'.
flat_text(Top) ->
    ?Syn:flat_text(Top).

%% @spec root_path(node()) -> [{atom(), node()}]
%% @doc Returns the path from the root node to `Node'. Every path element
%% contains the link tag from the previous node and the next node. When the
%% path is not unique, the leftmost path in the syntax tree is selected.
root_path(Node) ->
    ?Syn:root_path(Node).

%% @spec root_path(node(), left|right) -> [{atom(), node()}]
%% @doc Returns the path from the root node to `Node'. Every path element
%% contains the link tag from the previous node and the next node. When the
%% path is not unique, `Choose' decides which path is taken: `left' chooses
%% the leftmost path in the syntax tree, `right' chooses the rightmost path.
root_path(Node, Choose) ->
    ?Syn:root_path(Node, Choose).

%% @spec get_file(list() | node()) -> [node()]
%% @doc Returns the file that defines the node.
get_file(Lst) ->
    ?Syn:get_file(Lst).