%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% @doc Map properties and map based queries

-module(reflib_map).
-vsn("$Rev: $ ").

%% =============================================================================
%% Exports

-export([find/1, keys/0, key/1, id/1, funform/0, mapdef/0, references/0]).

-include("lib.hrl").

%% =============================================================================

%% @spec id(node(#map{})) -> integer()
%% @doc The id of the map object
id(Map) ->
    (?Graph:data(Map))#map.id.

%% @spec find(integer()) -> query(#form{}, #map{})
%% @doc The result query returns the map with id `Id'
find(MapId) ->
    [{map, {id, '==', MapId}}].

%% @spec keys() -> query(#map{}, #mapkey{})
%% @doc The result query returns the keys of the map
keys() ->
    [key].

%% @spec key(integer()) -> query(#map{}, #mapkey{})
%% @doc The result query returns the map's key with id `Id'
key(KeyId) ->
    [{key, {id, '==', KeyId}}].

%% @spec funform() -> query(#map{}, #form{})
%% @doc The result query returns the function form that defines the map
funform() ->
    [{map, back}].

%% @spec mapdef() -> query(#map{}, #expression{})
%% @doc The result query returns the expression that defines the map
mapdef() ->
    [{mapdef, back}].

%% @spec references() -> query(#map{}, #expression{})
%% @doc The result query returns every reference to the map
references() ->
    [{mapref, back}].

