/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;

public class OtpMsg {
    public static final int linkTag = 1;
    public static final int sendTag = 2;
    public static final int exitTag = 3;
    public static final int unlinkTag = 4;
    public static final int regSendTag = 6;
    public static final int exit2Tag = 8;
    protected int tag;
    protected OtpInputStream paybuf;
    protected OtpErlangObject payload;
    protected OtpErlangPid from;
    protected OtpErlangPid to;
    protected String toName;

    OtpMsg(OtpErlangPid otpErlangPid, OtpInputStream otpInputStream) {
        this.tag = 2;
        this.from = null;
        this.to = otpErlangPid;
        this.toName = null;
        this.paybuf = otpInputStream;
        this.payload = null;
    }

    OtpMsg(OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) {
        this.tag = 2;
        this.from = null;
        this.to = otpErlangPid;
        this.toName = null;
        this.paybuf = null;
        this.payload = otpErlangObject;
    }

    OtpMsg(OtpErlangPid otpErlangPid, String string, OtpInputStream otpInputStream) {
        this.tag = 6;
        this.from = otpErlangPid;
        this.toName = string;
        this.to = null;
        this.paybuf = otpInputStream;
        this.payload = null;
    }

    OtpMsg(OtpErlangPid otpErlangPid, String string, OtpErlangObject otpErlangObject) {
        this.tag = 6;
        this.from = otpErlangPid;
        this.toName = string;
        this.to = null;
        this.paybuf = null;
        this.payload = otpErlangObject;
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) {
        this.tag = n;
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
        this.paybuf = null;
        this.payload = otpErlangObject;
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, String string) {
        this.tag = n;
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
        this.paybuf = null;
        this.payload = new OtpErlangAtom(string);
    }

    OtpMsg(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        if (n > 10) {
            n -= 10;
        }
        this.tag = n;
        this.from = otpErlangPid;
        this.to = otpErlangPid2;
    }

    OtpInputStream getMsgBuf() {
        return this.paybuf;
    }

    public int type() {
        return this.tag;
    }

    public OtpErlangObject getMsg() throws OtpErlangDecodeException {
        if (this.payload == null) {
            this.payload = this.paybuf.read_any();
        }
        return this.payload;
    }

    public String getRecipientName() {
        return this.toName;
    }

    public OtpErlangPid getRecipientPid() {
        return this.to;
    }

    public Object getRecipient() {
        if (this.toName != null) {
            return this.toName;
        }
        return this.to;
    }

    public OtpErlangPid getSenderPid() {
        return this.from;
    }
}

