/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;

public class OtpErlangFun
extends OtpErlangObject
implements Serializable {
    private static final long serialVersionUID = -3423031125356706472L;
    private final OtpErlangPid pid;
    private final String module;
    private final long index;
    private final long old_index;
    private final long uniq;
    private final OtpErlangObject[] freeVars;
    private final int arity;
    private final byte[] md5;

    public OtpErlangFun(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        OtpErlangFun otpErlangFun = otpInputStream.read_fun();
        this.pid = otpErlangFun.pid;
        this.module = otpErlangFun.module;
        this.arity = otpErlangFun.arity;
        this.md5 = otpErlangFun.md5;
        this.index = otpErlangFun.index;
        this.old_index = otpErlangFun.old_index;
        this.uniq = otpErlangFun.uniq;
        this.freeVars = otpErlangFun.freeVars;
    }

    public OtpErlangFun(OtpErlangPid otpErlangPid, String string, long l, long l2, OtpErlangObject[] otpErlangObjectArray) {
        this.pid = otpErlangPid;
        this.module = string;
        this.arity = -1;
        this.md5 = null;
        this.index = l;
        this.old_index = 0L;
        this.uniq = l2;
        this.freeVars = otpErlangObjectArray;
    }

    public OtpErlangFun(OtpErlangPid otpErlangPid, String string, int n, byte[] byArray, int n2, long l, long l2, OtpErlangObject[] otpErlangObjectArray) {
        this.pid = otpErlangPid;
        this.module = string;
        this.arity = n;
        this.md5 = byArray;
        this.index = n2;
        this.old_index = l;
        this.uniq = l2;
        this.freeVars = otpErlangObjectArray;
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_fun(this.pid, this.module, this.old_index, this.arity, this.md5, this.index, this.uniq, this.freeVars);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangFun)) {
            return false;
        }
        OtpErlangFun otpErlangFun = (OtpErlangFun)object;
        if (!this.pid.equals(otpErlangFun.pid) || !this.module.equals(otpErlangFun.module) || this.arity != otpErlangFun.arity) {
            return false;
        }
        if (this.md5 == null ? otpErlangFun.md5 != null : !this.md5.equals(otpErlangFun.md5)) {
            return false;
        }
        if (this.index != otpErlangFun.index || this.uniq != otpErlangFun.uniq) {
            return false;
        }
        if (this.freeVars == null) {
            return otpErlangFun.freeVars == null;
        }
        return this.freeVars.equals(otpErlangFun.freeVars);
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(1);
        hash.combine(this.pid.hashCode(), this.module.hashCode());
        hash.combine(this.arity);
        if (this.md5 != null) {
            hash.combine(this.md5);
        }
        hash.combine(this.index);
        hash.combine(this.uniq);
        if (this.freeVars != null) {
            for (OtpErlangObject otpErlangObject : this.freeVars) {
                hash.combine(otpErlangObject.hashCode(), 1);
            }
        }
        return hash.valueOf();
    }

    @Override
    public String toString() {
        return "#Fun<" + this.module + "." + this.old_index + "." + this.uniq + ">";
    }
}

