/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;

public class OtpErlangAtom
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3204386396807876641L;
    public static final int maxAtomLength = 255;
    private final String atom;

    public OtpErlangAtom(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string value");
        }
        if (string.codePointCount(0, string.length()) > 255) {
            throw new IllegalArgumentException("Atom may not exceed 255 characters: " + string);
        }
        this.atom = string;
    }

    public OtpErlangAtom(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        this.atom = otpInputStream.read_atom();
    }

    public OtpErlangAtom(boolean bl) {
        this.atom = String.valueOf(bl);
    }

    public String atomValue() {
        return this.atom;
    }

    public boolean booleanValue() {
        return Boolean.valueOf(this.atomValue());
    }

    @Override
    public String toString() {
        if (this.atomNeedsQuoting(this.atom)) {
            return "'" + this.escapeSpecialChars(this.atom) + "'";
        }
        return this.atom;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangAtom)) {
            return false;
        }
        OtpErlangAtom otpErlangAtom = (OtpErlangAtom)object;
        return this.atom.compareTo(otpErlangAtom.atom) == 0;
    }

    @Override
    protected int doHashCode() {
        return this.atom.hashCode();
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_atom(this.atom);
    }

    private boolean isErlangDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isErlangUpper(char c) {
        return c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isErlangLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isErlangLetter(char c) {
        return this.isErlangLower(c) || this.isErlangUpper(c);
    }

    private boolean atomNeedsQuoting(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (!this.isErlangLower(string.charAt(0))) {
            return true;
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (this.isErlangLetter(c) || this.isErlangDigit(c) || c == '@') continue;
            return true;
        }
        return false;
    }

    private String escapeSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block13: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block13;
                }
                case '\u007f': {
                    stringBuffer.append("\\d");
                    continue block13;
                }
                case '\u001b': {
                    stringBuffer.append("\\e");
                    continue block13;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block13;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block13;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block13;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block13;
                }
                case '\u000b': {
                    stringBuffer.append("\\v");
                    continue block13;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block13;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block13;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block13;
                }
                default: {
                    if (c < '\u0017') {
                        stringBuffer.append("\\^" + (char)(64 + c));
                        continue block13;
                    }
                    if (c > '~') {
                        stringBuffer.append("\\" + Integer.toOctalString(c));
                        continue block13;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return new String(stringBuffer);
    }
}

